@extends('layouts.master')
@section('content')
    <div class="card">
        <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between">
            <h5>Room type list</h5>
            <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#routeModal" data-action="create">Create New Route</button>
            @if ($message = Session::get('success'))
                <div class="alert alert-success mt-3">
                    <p>{{ $message }}</p>
                </div>
            @endif
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-12">
                    <table class="table" id="myTable">
                        <thead class="thead-light">
                            <tr>
                                <th>SN</th>
                                <th>Route Name</th>
                                <th>Start Point</th>
                                <th>End Point</th>
                                <th>Vehicle No</th>
                                <th>Driver ID</th>
                                <th>Departure Time</th>
                                <th>Arrival Time</th>
                                <th width="280px">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $sn = 0;
                            @endphp
                            @foreach ($routes as $route)
                                <tr>
                                    <td>{{ ++$sn }}</td>
                                    <td>{{ $route->route_name }}</td>
                                    <td>{{ $route->start_point }}</td>
                                    <td>{{ $route->end_point }}</td>
                                    <td>{{ $route->vehicle_no }}</td>
                                    <td>{{ $route->driver_id }}</td>
                                    <td>{{ $route->departure_time }}</td>
                                    <td>{{ $route->arrival_time }}</td>
                                    <td>
                                        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#routeModal"
                                            data-action="edit" data-id="{{ $route->id }}"
                                            data-route_name="{{ $route->route_name }}"
                                            data-start_point="{{ $route->start_point }}"
                                            data-end_point="{{ $route->end_point }}"
                                            data-vehicle_no="{{ $route->vehicle_no }}"
                                            data-driver_id="{{ $route->driver_id }}"
                                            data-departure_time="{{ $route->departure_time }}"
                                            data-arrival_time="{{ $route->arrival_time }}">
                                            Edit
                                        </button>
                                        <form action="{{ route('transport_routes.destroy', $route->id) }}" method="POST"
                                            style="display:inline;">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger">Delete</button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="routeModal" tabindex="-1" aria-labelledby="routeModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form id="routeForm" method="POST">
                    @csrf
                    @method('POST')
                    <div class="modal-header">
                        <h5 class="modal-title" id="routeModalLabel">Create/Edit Route</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="route_name">Route Name</label>
                            <input type="text" name="route_name" id="route_name" class="form-control" required>
                        </div>

                        <div class="form-group">
                            <label for="start_point">Start Point</label>
                            <input type="text" name="start_point" id="start_point" class="form-control" required>
                        </div>

                        <div class="form-group">
                            <label for="end_point">End Point</label>
                            <input type="text" name="end_point" id="end_point" class="form-control" required>
                        </div>

                        <div class="form-group">
                            <label for="vehicle_no">Vehicle No</label>
                            <input type="text" name="vehicle_no" id="vehicle_no" class="form-control" required>
                        </div>

                        <div class="form-group">
                            <label for="driver_id">Driver ID</label>
                            <input type="number" name="driver_id" id="driver_id" class="form-control" required>
                        </div>

                        <div class="form-group">
                            <label for="departure_time">Departure Time</label>
                            <input type="time" name="departure_time" id="departure_time" class="form-control" required>
                        </div>

                        <div class="form-group">
                            <label for="arrival_time">Arrival Time</label>
                            <input type="time" name="arrival_time" id="arrival_time" class="form-control" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Save changes</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
<script type="text/javascript">
   $(document).ready(function() {
        $('#routeModal').on('show.bs.modal', function(event) {
            var button = $(event.relatedTarget);
            var action = button.data('action');
            var modal = $(this);
            var form = modal.find('form');

            // Reset the form action and fields
            form.trigger("reset");

            if (action === 'edit') {
                // Set form action for updating the route
                form.attr('action', '/transport-routes/' + button.data('id'));
                modal.find('[name="_method"]').val('PUT');
                modal.find('.modal-title').text('Edit Route');

                // Populate the form fields with the existing data
                modal.find('#route_name').val(button.data('route_name'));
                modal.find('#start_point').val(button.data('start_point'));
                modal.find('#end_point').val(button.data('end_point'));
                modal.find('#vehicle_no').val(button.data('vehicle_no'));
                modal.find('#driver_id').val(button.data('driver_id'));
                modal.find('#departure_time').val(button.data('departure_time'));
                modal.find('#arrival_time').val(button.data('arrival_time'));

            } else {
                // Set form action for creating a new route
                form.attr('action', '{{ route("transport-route.store") }}');
                modal.find('[name="_method"]').val('POST');
                modal.find('.modal-title').text('Create New Route');
            }
        });
    });
</script>
@endsection
